<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_contact_info_widget');
	function dogri_contact_info_widget() {
		register_widget('dogri_contact_info_widget');
	}
	
	
	class Dogri_Contact_Info_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_contact_info_widget',esc_html__('Dogri Contact Info Widget','dogri-toolkit'),array(
				'description' => esc_html__('Dogri Contact Info Widget','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
             if($instance['title']):
                echo $before_title; ?> 
                    <?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
                <?php echo $after_title; ?>
            <?php endif; ?>
		
			<?php 
			if( $subscribe_style === 'style_1'): ?>

				<div class="footer-widget-info">	
					<div class="footer-info mb-35">
                        <div class="footer-info-item d-flex align-items-start">
                           <div class="footer-info-icon mr-20">
                              <span> <i class="fa-solid fa-location-dot"></i></span>
                           </div>

						   <?php
							if( $address !== ""): ?>
                           <div class="footer-info-text">
                              <a href="#"><?php echo wp_kses_post( $address ); ?></a>
                           </div>
						   <?php
							endif; ?>

                        </div>
                        <div class="footer-info-item d-flex align-items-start">
                           <div class="footer-info-icon mr-20">
                              <span><i class="fa-solid fa-envelope"></i></span>
                           </div>

						   <?php
							if( $email !== ""): ?>
                           <div class="footer-info-text">
						   		<a href="mailto:<?php echo esc_attr( $email ); ?>"><?php echo wp_kses_post( $email ); ?></a>
                           </div>
						   <?php
							endif; ?>

                        </div>
                        <div class="footer-info-item d-flex align-items-start">
                           <div class="footer-info-icon mr-20">
                              <span><i class="fa-solid fa-phone"></i></span>
                           </div>

						   <?php
							if( $phone !== ""): ?>
                           <div class="footer-info-text">
                              <a href="tel:<?php echo esc_attr( $phone ); ?>"><?php echo wp_kses_post( $phone ); ?></a>
                           </div>
						   <?php
							endif; ?>

                        </div>
                     </div>
					<div class="theme-social">
						<?php 
						if($facebook !== ""): ?>
							<a href="<?php print esc_url($facebook); ?>"><i class="fa-brands fa-facebook-f"></i></a>
						<?php 
						endif; ?>

						<?php 
						if($twitter !== ""): ?>
							<a href="<?php print esc_url($twitter); ?>"><i class="fa-brands fa-twitter"></i></a>
						<?php 
						endif; ?>

						<?php
						if($instagram !== ""): ?>
							<a href="<?php print esc_url($instagram); ?>"><i class="fa-brands fa-instagram"></i></a>
						<?php 
						endif; ?>

						<?php 
						
						if($pinterest !== "" ): ?>
							<a href="<?php print esc_url($pinterest); ?>"><i class="fa-brands fa-pinterest-p"></i></a>
						<?php
						endif; ?>
					</div>
				</div>

			<?php 
			elseif( $subscribe_style === 'style_2'): ?>
				<div class="footer-widget-info">
                        
					<div class="theme-social">
						<?php 
						if($facebook !== ""): ?>
							<a href="<?php print esc_url($facebook); ?>"><i class="fa-brands fa-facebook-f"></i></a>
						<?php 
						endif; ?>

						<?php 
						if($twitter !== ""): ?>
							<a href="<?php print esc_url($twitter); ?>"><i class="fa-brands fa-twitter"></i></a>
						<?php 
						endif; ?>

						<?php
						if($instagram !== ""): ?>
							<a href="<?php print esc_url($instagram); ?>"><i class="fa-brands fa-instagram"></i></a>
						<?php 
						endif; ?>

						<?php 
						
						if($pinterest !== "" ): ?>
							<a href="<?php print esc_url($pinterest); ?>"><i class="fa-brands fa-pinterest-p"></i></a>
						<?php
						endif; ?>
					</div>
			


			<?php
			endif; ?>	


	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$subscribe_style  = isset($instance['subscribe_style'])? $instance['subscribe_style'] : 'style_1';
			$address  = isset($instance['address'])? $instance['address']:'';
			$email  = isset($instance['email'])? $instance['email']:'';
			$phone  = isset($instance['phone'])? $instance['phone']:'';

			$facebook  = isset($instance['facebook'])? $instance['facebook']:'';
			$twitter  = isset($instance['twitter'])? $instance['twitter']:'';
			$instagram  = isset($instance['instagram'])? $instance['instagram']:'';
			$pinterest  = isset($instance['pinterest'])? $instance['pinterest']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">
			<p>
				<label for="<?php echo $this->get_field_id('subscribe_style'); ?>">Choose Style</label>
				<select name="<?php echo $this->get_field_name('subscribe_style'); ?>" id="<?php echo $this->get_field_id('subscribe_style'); ?>" class="widefat">

					<option value="" disabled="disabled">Select Subscribe Style</option>
					<option value="style_1" <?php if($subscribe_style === 'style_1'){ echo 'selected="selected"'; } ?>>Style 1</option>
					<option value="style_2" <?php if($subscribe_style === 'style_2'){ echo 'selected="selected"'; } ?>>Style 2</option>
				</select>
			</p>

			<p>
				<label for="address"><?php esc_html_e('Address:','dogri-toolkit'); ?></label>
			</p>

			<textarea class="widefat" rows="2" cols="15" id="<?php print esc_attr($this->get_field_id('address')); ?>" value="<?php print esc_attr($address); ?>" name="<?php print esc_attr($this->get_field_name('address')); ?>"><?php print esc_attr($address); ?></textarea>

			<p>
				<label for="email"><?php esc_html_e('Email Address:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('email')); ?>"  name="<?php print esc_attr($this->get_field_name('email')); ?>" value="<?php print esc_attr($email); ?>">

			<p>
				<label for="phone"><?php esc_html_e('Phone Number:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('phone')); ?>"  name="<?php print esc_attr($this->get_field_name('phone')); ?>" value="<?php print esc_attr($phone); ?>">



			<p>
				<label for="title"><?php esc_html_e('Facebook:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('facebook')); ?>"  name="<?php print esc_attr($this->get_field_name('facebook')); ?>" value="<?php print esc_attr($facebook); ?>">

			<p>
				<label for="title"><?php esc_html_e('Twitter:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('twitter')); ?>"  name="<?php print esc_attr($this->get_field_name('twitter')); ?>" value="<?php print esc_attr($twitter); ?>">


			<p>
				<label for="instagram"><?php esc_html_e('Instagram:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('instagram')); ?>"  name="<?php print esc_attr($this->get_field_name('instagram')); ?>" value="<?php print esc_attr($instagram); ?>">

			<p>
				<label for="pinterest"><?php esc_html_e('Pinterest:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('pinterest')); ?>"  name="<?php print esc_attr($this->get_field_name('pinterest')); ?>" value="<?php print esc_attr($pinterest); ?>">
			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['subscribe_style'] = ( ! empty( $new_instance['subscribe_style'] ) ) ? strip_tags( $new_instance['subscribe_style'] ) : '';
			$instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';
			$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';
			$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';

			$instance['facebook'] = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';
			$instance['twitter'] = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';
			$instance['instagram'] = ( ! empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : '';
			$instance['pinterest'] = ( ! empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : '';

			
			return $instance;
		}
	}