<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Banner_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'banner_slider';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Banner Slider', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'banner_slider',
			[
				'label' => esc_html__( 'Banner Slider', 'dogri-elementor' ),
			]
		);					
	
			$this->add_control(
				'title',
				[
					'label'       => __( 'Nav Title One', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);

			$this->add_control(
				'title1',
				[
					'label'       => __( 'Nav Title Two', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);


		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_bgimg' =>
								[
									'name' => 'block_bgimg',
									'label' => esc_html__('Background image', 'theme-elementor'),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								],

								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],								

								 'block_subtitle' =>
								 [
									 'name' => 'block_subtitle',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],	
								 
								 'block_button' =>
								 [
									'name' => 'block_button',
									'label'       => __( 'Button', 'theme-elementor' ),
									'type'        => Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your Button Title', 'theme-elementor' ),
									'default' => esc_html__('Read More', 'theme-elementor'),
								],
								 
								 'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'Button Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_button1' =>
								 [
									'name' => 'block_button1',
									'label'       => __( 'Video Title', 'theme-elementor' ),
									'type'        => Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your Button Title', 'theme-elementor' ),
									'default' => esc_html__('Read More', 'theme-elementor'),
								],
								 
								 'block_btnlink1' =>
								[
									'name' => 'block_btnlink1',
									'label' => __( 'Video Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],


								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	


			//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .slider-subtitle' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .slider-subtitle' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .slider-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .slider-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .slider-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3',
				'selector' => '{{WRAPPER}} .slider-title',
				'selector' => '{{WRAPPER}} .slider-subtitle',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .slider-subtitle' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-subtitle-3' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-title-3' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-title-3' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .slider-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-title-wrapper-3.is-white .section-title-3',
				'selector' => '{{WRAPPER}} .slider-title',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-title-wrapper-3.is-white .section-title-3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .slider-title' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		//Section Title Text==========================
		$this->start_controls_section(
			'section_title_text_settings',
			array(
				'label' => __( 'Section Title Text Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		
		$this->add_control(
			'show_section_title_text',
			array(
				'label' => esc_html__( 'Show Section Title Text', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .slider__navigation .slider-nav-prev p' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .slider__navigation .slider-nav-next p' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_title_text_alingment',
			array(
				'label' => esc_html__( 'Section Title Text Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .slider__navigation .slider-nav-prev p' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .slider__navigation .slider-nav-next p' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_text_margin',
			array(
				'label'     => __( 'Section Text Margin', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .slider__navigation .slider-nav-prev p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .slider__navigation .slider-nav-next p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		); 
		
		$this->add_control(
			'section_title_text_padding',
			array(
				'label'     => __( 'Section Text Padding', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .slider__navigation .slider-nav-prev p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .slider__navigation .slider-nav-next p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_text_typography',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .slider__navigation .slider-nav-prev p',
				'selector' => '{{WRAPPER}} .slider__navigation .slider-nav-next p',
			)
		);
		
		$this->add_control(
			'section_title_text_color',
			array(
				'label'     => __( 'Section Text Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .slider__navigation .slider-nav-prev p' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .slider__navigation .slider-nav-next p' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Section Title Text=========	


		    //Background Color ==========================

			$this->start_controls_section(
				'bg_color_block_settings',
				array(
					'label' => __( 'Background Color Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);			
		
			$this->add_control(
				'block_bg_color',
				array(
					'label'     => __( 'Nav Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .slider__navigation .slider-nav-prev' => 'background-color: {{VALUE}} !important',
					),
				)
			);

			$this->add_control(
				'block_bg_color1',
				array(
					'label'     => __( 'Nav Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .slider__navigation .slider-nav-next' => 'background-color: {{VALUE}} !important',
					),
				)
			);
		
			$this->end_controls_section();
		
			//End of Background Color  

			
	//========== Button with Background ===================================

	$this->start_controls_section(
		'button_control',
		array(
			'label' => __( 'Button Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_button',
		array(
			'label' => esc_html__( 'Show Button', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .fill-btn' => 'display: {{VALUE}} !important',
			),
		)
	);		
	$this->add_control(
		'button_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'condition'    => array( 'show_button' => 'show' ),
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .fill-btn' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_color',
		array(
			'label'     => __( 'Button Text Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .fill-btn' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .fill-btn' => 'background: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_hover_color',
		array(
			'label'     => __( 'Text Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .fill-btn:hover' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_hover_color',
		array(
			'label'     => __( 'Background Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .fill-btn:before' => 'background: {{VALUE}} !important',
			),
		)
	);				
	$this->add_control(
		'button_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'button_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
			'selectors' => array(
				'{{WRAPPER}} .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'button_typography',
			'condition'    => array( 'show_button' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .fill-btn',
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		array(
			'name' => 'border',
			'condition'    => array( 'show_button' => 'show' ),
			'selector' => '{{WRAPPER}} .fill-btn',
		)
	);
	$this->add_control(
		'border_radius',
		array(
			'label' => esc_html__( 'Border Radius', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1000,
					'step' => 5,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
			'selectors' => [
				'{{WRAPPER}} .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		)
	);

	$this->end_controls_section();

	//End of Button	


	//Section Padding Block==========================
	$this->start_controls_section(
		'section_padding_settings',
		array(
			'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'block_margin',
		array(
			'label'     => __( 'Block Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .slider-height' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->add_control(
		'block_padding',
		array(
			'label'     => __( 'Block Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .slider-height' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->end_controls_section();
	//End of Section Padding Block 




	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 

var doctor = new Swiper(".doctor-slider-active", {
	slidesPerView: 3,
	spaceBetween: 30,
	loop: true,
	autoplay: {
		delay: 3000,
	},
	navigation: {
		nextEl: ".doctor-slider-button-next",
		prevEl: ".doctor-slider-button-prev",
	},
	pagination: {
		el: ".bd-swiper-dot",
		clickable: true,
	},
	breakpoints: {
		"1200": {
			slidesPerView: 3,
		},
	"992": {
			slidesPerView: 2,
		},
		"768": {
			slidesPerView: 2,
		},
		"576": {
			slidesPerView: 1,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});

//write code above the line 

  });
</script>';


?>

 <!-- Slider area start -->
 		<section class="slider-area">
         <div class="swiper slider-active">
            <div class="swiper-wrapper">
				<?php foreach($settings['repeat'] as $item):?>
               <div class="swiper-slide">
                  <div class="singel-slider slider-height include-bg"
                     data-background="<?php echo wp_get_attachment_url($item['block_bgimg']['id']);?>">
                     <div class="row gy-50">
                        <div class="col-xxl-5 col-xl-6 col-lg-8 col-md-10">
                           <div class="slider-content">
                              <h2 class="slider-title"><span class="text-color-1"><?php echo wp_kses($item['block_title'], $allowed_tags);?></h2>
                              <span class="slider-subtitle"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
                              <div class="slider-btn-wrapper">
                                 <a href="<?php echo esc_url($item['block_btnlink']['url']);?>" class="fill-btn">
                                    <span class="fill-btn-inner">
                                       <span class="fill-btn-normal"><?php echo wp_kses($item['block_button'], $allowed_tags);?><i
                                             class="fa-regular fa-angle-right"></i></span>
                                       <span class="fill-btn-hover"><?php echo wp_kses($item['block_button'], $allowed_tags);?><i
                                             class="fa-regular fa-angle-right"></i></span>
                                    </span>
                                 </a>
                                 <div class="slide-video">
                                    <a class="slider-link popup-video"
                                       href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><i
                                          class="fa-sharp fa-solid fa-play"></i></a>
                                    <span><?php echo wp_kses($item['block_button1'], $allowed_tags);?></span>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
			   <?php endforeach; ?>
            </div>
            <div class="slider-pagination">
               <div class="banner-dot-2"></div>
            </div>
            <div class="slider__navigation d-none d-md-flex">
               <div class="slider-nav-prev">
                  <p><?php echo esc_attr($settings['title']);?></p>
                  <button class="slider-button-prev">
                     <span><i class="fa-regular fa-angle-right"></i></span>
                  </button>
               </div>
               <div class="slider-nav-next">
                  <p><?php echo esc_attr($settings['title1']);?></p>
                  <button class="slider-button-next">
                     <span><i class="fa-regular fa-angle-right"></i></span>
                  </button>
               </div>
            </div>
         </div>
      </section>
      <!-- Slider area end -->


             
		<?php 
	}


}