<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Team_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'team_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'team_widget',
			[
				'label' => esc_html__( 'Team Widget', 'dogri-elementor' ),
			]
		);	

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'dogri-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'dogri-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'dogri-elementor' ),
				),
			]
		);
		
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
			]
		);
		
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);
	
			$this->add_control(
				'text',
				[
					'label'       => __( 'Description Text', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter Your Description', 'dogri-elementor' ),
				]
			);
			
		$this->add_control(
			'bttn',
			[
				'label'       => __( 'Button', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your Button Title', 'dogri-elementor' ),
				'default' => esc_html__('Read More', 'dogri-elementor'),
			]
		);	


		$this->add_control(
				'btnlink',
				[
				'label' => __( 'Button Url', 'dogri-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				
			]
			);




		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_image' =>
								[
									'name' => 'block_image',
									'label' => __( 'Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								  ],	

								  'block_alt_text' =>
								  [
								  'name' => 'block_alt_text',
								  'label' => esc_html__('Image Alt Text', 'dogri-elementor'),
								  'type' => Controls_Manager::TEXTAREA,
								  'default' => esc_html__('', 'dogri-elementor')
								  ],

								  'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'image Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],


								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_btnlink1' =>
								[
									'name' => 'block_btnlink1',
									'label' => __( 'Title Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_subtitle' =>
								 [
									 'name' => 'block_subtitle',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],

								 'block_btnlink2' =>
								[
									'name' => 'block_btnlink2',
									'label' => __( 'Fb Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_btnlink3' =>
								[
									'name' => 'block_btnlink3',
									'label' => __( 'Twitter Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_btnlink4' =>
								[
									'name' => 'block_btnlink4',
									'label' => __( 'LinkedIn Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_btnlink5' =>
								 [
									 'name' => 'block_btnlink5',
									 'label' => __( 'Instagram Url', 'dogri-elementor' ),
									 'type' => Controls_Manager::URL,
									 'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									 'show_external' => true,
									 'default' => [
									   'url' => '',
									   'is_external' => true,
									   'nofollow' => true,
									 ],
								  ],																
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-subtitle span' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'display: {{VALUE}} !important',
				), 
			)
		);

		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .team-area .section-subtitle' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'text-align: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .team-area .section-subtitle span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .team-area .section-subtitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),

			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .team-area .section-subtitle span',
				'selector' => '{{WRAPPER}} .section-subtitle-5',
			)
		);


		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-subtitle span' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-subtitle span' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	

		
		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .team-area .section-title' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .team-area .section-title',
				'selector' => '{{WRAPPER}} .section-title-3',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	
		

		//Section Title Text==========================
		$this->start_controls_section(
			'section_title_text_settings',
			array(
				'label' => __( 'Section Title Text Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		
		$this->add_control(
			'show_section_title_text',
			array(
				'label' => esc_html__( 'Show Section Title Text', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title-wrapper p' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_title_text_alingment',
			array(
				'label' => esc_html__( 'Section Title Text Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title-wrapper p' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_text_margin',
			array(
				'label'     => __( 'Section Text Margin', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title-wrapper p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		); 
		
		$this->add_control(
			'section_title_text_padding',
			array(
				'label'     => __( 'Section Text Padding', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title-wrapper p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_text_typography',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .team-area .section-title-wrapper p',
			)
		);
		
		$this->add_control(
			'section_title_text_color',
			array(
				'label'     => __( 'Section Text Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .team-area .section-title-wrapper p' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Section Title Text=========	


		
	//========== Button with Background ===================================

	$this->start_controls_section(
		'button_control',
		array(
			'label' => __( 'Button Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_button',
		array(
			'label' => esc_html__( 'Show Button', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn' => 'display: {{VALUE}} !important',
			),
		)
	);		
	$this->add_control(
		'button_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'condition'    => array( 'show_button' => 'show' ),
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_color',
		array(
			'label'     => __( 'Button Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn' => 'background: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn:before' => 'background: {{VALUE}} !important',
			),
		)
	);				
	$this->add_control(
		'button_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'button_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
			'selectors' => array(
				'{{WRAPPER}} .team-area .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'button_typography',
			'condition'    => array( 'show_button' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .team-area .fill-btn',
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		array(
			'name' => 'border',
			'condition'    => array( 'show_button' => 'show' ),
			'selector' => '{{WRAPPER}} .team-area .fill-btn',
		)
	);
	$this->add_control(
		'border_radius',
		array(
			'label' => esc_html__( 'Border Radius', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1000,
					'step' => 5,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
			'selectors' => [
				'{{WRAPPER}} .team-area .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		)
	);

	$this->end_controls_section();

	//End of Button	


	// Title 	==================	


	$this->start_controls_section(
		'title_settings',
		array(
			'label' => __( 'Title Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
			
	$this->add_control(
		'show_title',
		array(
			'label' => esc_html__( 'Show Title', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .team-title' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content h4' => 'display: {{VALUE}} !important',
			),   
		)
	);
	
	$this->add_control(
		'title_alignment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_title' => 'show' ),
			'toggle' => true,
			'selectors' => array(
			
				'{{WRAPPER}} .team-title' => 'text-align: {{VALUE}}',
				'{{WRAPPER}} .doctor-content h4' => 'text-align: {{VALUE}}',
			),
		)
	);
	
	$this->add_control(
		'title_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .team-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .doctor-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'title_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .team-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .doctor-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'title_typography',
			'condition'    => array( 'show_title' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .team-title',
			'selector' => '{{WRAPPER}} .doctor-content h4',
		)
	);
	
	$this->add_control(
		'title_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-title' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content h4' => 'color: {{VALUE}} !important',
	
			),
		)
	);

	$this->add_control(
		'title_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-title:hover' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content h4:hover' => 'color: {{VALUE}} !important',
	
			),
		)
	);

	$this->end_controls_section();	
	
	
	//End of  Title 	==================


	//Text==========================
	$this->start_controls_section(
		'text_settings',
		array(
			'label' => __( 'Text Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'show_text',
		array(
			'label' => esc_html__( 'Show Text', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .team-content p' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content span' => 'display: {{VALUE}} !important',
			),   
		)
	);
	
	$this->add_control(
		'text_alignment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_text' => 'show' ),
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .team-content p' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content span' => 'text-align: {{VALUE}} !important',
			), 
		)
	);
	
	$this->add_control(
		'text_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
			'condition'    => array( 'show_text' => 'show' ),
			'selectors' => array(
				'{{WRAPPER}} .team-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .doctor-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_control(
		'text_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
			'condition'    => array( 'show_text' => 'show' ),
			'selectors' => array(
				'{{WRAPPER}} .team-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .doctor-content span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'text_typography',
			'condition'    => array( 'show_text' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .team-content p',
			'selector' => '{{WRAPPER}} .doctor-content span',
		)
	); 
	
	$this->add_control(
		'text_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_text' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-content p' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content span' => 'color: {{VALUE}} !important',
			),
		)
	);

	$this->add_control(
		'text_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_text' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .team-content p:hover' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .doctor-content span:hover' => 'color: {{VALUE}} !important',
			),
		)
	);

	$this->end_controls_section();
	//End of Text=========	


	//Section Padding Block==========================
	$this->start_controls_section(
		'section_padding_settings',
		array(
			'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'block_margin',
		array(
			'label'     => __( 'Block Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .team-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->add_control(
		'block_padding',
		array(
			'label'     => __( 'Block Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .team-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->end_controls_section();
	//End of Section Padding Block 


	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 

var doctor = new Swiper(".doctor-slider-active", {
	slidesPerView: 3,
	spaceBetween: 30,
	loop: true,
	autoplay: {
		delay: 3000,
	},
	navigation: {
		nextEl: ".doctor-slider-button-next",
		prevEl: ".doctor-slider-button-prev",
	},
	pagination: {
		el: ".bd-swiper-dot",
		clickable: true,
	},
	breakpoints: {
		"1200": {
			slidesPerView: 3,
		},
		"992": {
			slidesPerView: 2,
		},
		"768": {
			slidesPerView: 2,
		},
		"576": {
			slidesPerView: 1,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});

//write code above the line 

  });
</script>';


?>


<?php  if ( 'style1' === $settings['style'] ) : ?>
<!-- Team area start -->
<section class="team-area border-up section-space">
	<div class="container">
		<div class="row gy-5">
		<div class="col-xxl-4 col-xl-4 col-lg-4">
			<div class="section-title-wrapper">
				<div class="section-subtitle">
					<span><?php echo $settings['subtitle'];?></span>
				</div>
				<h2 class="section-title mb-25"><?php echo $settings['title'];?></h2>
				<p class="mb-35"><?php echo $settings['text'];?></p>
				<a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="fill-btn">
					<span class="fill-btn-inner">
					<span class="fill-btn-normal"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
					<span class="fill-btn-hover"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
					</span>
				</a>
			</div>
		</div>
		<?php foreach($settings['repeat'] as $item):?>
		<div class="col-xxl-4 col-xl-4 col-lg-4">
			<div class="team-item text-center">
				<div class="team-thumb fix">
					<a href="<?php echo esc_url($item['block_btnlink']['url']);?>">
					<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
					</a>
				</div>
				<div class="team-content">
					<h3 class="team-title"><a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h3>
					<p><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></p>
					<div class="team-social d-flex justify-content-center gap-3">
					<a href="<?php echo esc_url($item['block_btnlink2']['url']);?>"><i class="fa-brands fa-facebook-f"></i></a>
					<a href="<?php echo esc_url($item['block_btnlink3']['url']);?>"><i class="fa-brands fa-twitter"></i></a>
					<a href="<?php echo esc_url($item['block_btnlink4']['url']);?>"><i class="fa-brands fa-linkedin-in"></i></a>
					</div>
				</div>
			</div>
		</div>
		<?php endforeach; ?>
		</div>
	</div>
</section>
<!-- Team area end -->

<?php  elseif ( 'style2' === $settings['style'] ) : ?>

<!-- Doctor area start -->
<section class="doctor-area section-space">
	<div class="container">
		<div class="row g-5 align-items-end section-title-space">
			<div class="col-xl-5 co-xl-6 col-lg-6 col-md-8">
				<?php if($settings['title']): ?>
				<div class="section-title-wrapper-4 sec">
					<span class="section-subtitle-5 mb-25"><?php echo $settings['subtitle'];?></span>
					<h2 class="section-title-3"><?php echo $settings['title'];?></h2>
				</div>
				<?php endif; ?>
			</div>
			<div class="col-xl-6 co-xl-6 col-lg-6 col-md-4">
				<div class="common-slider-navigation d-flex justify-content-start justify-content-md-end">
					<button class="doctor-slider-button-prev"><i class="fa-regular fa-arrow-left"></i></button>
					<button class="doctor-slider-button-next"><i class="fa-regular fa-arrow-right"></i></button>
				</div>
			</div>
		</div>
		<div class="row wow fadeIn" data-wow-delay=".3s">
			<div class="col-12">
				<div class="swiper doctor-slider-active">
					<div class="swiper-wrapper">
					<?php foreach($settings['repeat'] as $item):?>
					<div class="swiper-slide">
						<div class="doctor-item text-center">
							<div class="doctor-thumb">
							<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
							</div>
							<div class="doctor-content">
								<h4><a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
								<span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
							</div>
							<div class="doctor-social">
							<a href="<?php echo esc_url($item['block_btnlink2']['url']);?>"><i class="fa-brands fa-facebook-f"></i></a>
							<a href="<?php echo esc_url($item['block_btnlink3']['url']);?>"><i class="fa-brands fa-twitter"></i></a>
							<a href="<?php echo esc_url($item['block_btnlink4']['url']);?>"><i class="fa-brands fa-linkedin-in"></i></a>
							<a href="<?php echo esc_url($item['block_btnlink5']['url']);?>"><i class="fa-brands fa-instagram"></i></a>
							</div>
						</div>
					</div>
					<?php endforeach; ?>
					</div>
					<div class="doctor-slidertext-center">
					<div class="bd-swiper-dot"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- Doctor area end -->

<?php endif; ?>	

             
		<?php 
	}


}