<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package dogri
 */

/**
*
* dogri header
*/
add_action('dogri_header_style', 'dogri_check_header', 10);

function dogri_check_header() {
    $dogri_header_style = get_post_meta( get_the_ID(), 'dogri_choice_header_style', true );
    $dogri_default_header_style = get_theme_mod('choose_default_header', 'header-style-2' );

    if( $dogri_header_style == 'header-style-1' ) {
        dogri_header_style_1();
    }
    elseif( $dogri_header_style == 'header-style-2' ) {
        dogri_header_style_2();
    }  
    elseif( $dogri_header_style == 'header-style-3' ) {
        dogri_header_style_3();
    }  
    elseif( $dogri_header_style == 'header-style-4' ) {
        dogri_header_style_4();
    }elseif( $dogri_header_style == 'header-style-5' ) {
        dogri_header_style_5();
    }  
    else {
        
        /** default header style **/
        if($dogri_default_header_style == 'header-style-1'){
            dogri_header_style_1();
        }elseif($dogri_default_header_style == 'header-style-2'){
            dogri_header_style_2();
        }elseif($dogri_default_header_style == 'header-style-3'){
            dogri_header_style_3();
        }elseif($dogri_default_header_style == 'header-style-4'){
            dogri_header_style_4();
        }

    }

}


/**
* header style 1 
*/
function dogri_header_style_1() {
    // $dogri_topbar_switch      = get_theme_mod('dogri_topbar_switch', false);
    $dogri_show_header_button = get_theme_mod('dogri_show_header_button', false);
    $btn_text_from_page         = get_post_meta(get_the_ID(), 'button_text_from_page', false);
    // $signup_page_link   = get_theme_mod('dogri_signup_page_link', '#'); 
    $phone_icon = get_template_directory_uri() . '/img/svg/phone-call.svg';
	$dogri_phone_icon = get_theme_mod('phone_icon', $phone_icon);

    if( $btn_text_from_page ){
        $btn_text               = get_post_meta(get_the_ID(), 'button_text_from_page', true);
        $btn_link               = get_post_meta(get_the_ID(), 'button_url_from_page', true);
    }else{
        $btn_text               = get_theme_mod('dogri_header_btn_text', esc_html__( 'Get A Quote', 'dogri' ));
        $btn_link               = get_theme_mod('dogri_header_btn_link', '#');
    }

    $header_contact_address     = get_theme_mod('dogri_header_contact_address', esc_html__( '8302 Preston Rd. Maine 9380', 'dogri' ));
    $header_contact_email       = get_theme_mod('dogri_header_contact_email', esc_html__( 'hello@dogri.com', 'dogri' ));
    $header_contact_phone               = get_theme_mod('dogri_header_contact_phone', esc_html__('+123-456-7890', 'dogri'));

    // $header_top_menu_one        = get_theme_mod('dogri_header_top_menu_one', esc_html__( 'FAQ', 'dogri' ));
    // $header_top_menu_one_link   = get_theme_mod('dogri_header_top_menu_one_link', '#'); 
    // $header_top_menu_two        = get_theme_mod('dogri_header_top_menu_two', esc_html__( 'Help', 'dogri' ));
    // $header_top_menu_two_link   = get_theme_mod('dogri_header_top_menu_two_link', '#');
    // $header_top_menu_three      = get_theme_mod('dogri_header_top_menu_three', esc_html__( 'Contact', 'dogri' ));
    // $header_top_menu_three_link   = get_theme_mod('dogri_header_top_menu_three_link', '#');

    $show_social_profiles       = get_theme_mod('dogri_header_social_profiles', true);

    $dogri_show_header_callus = get_theme_mod('dogri_show_header_callus', false);
    $header_phone_number      = get_theme_mod('dogri_header_callus', esc_html__( '+380961381876', 'dogri' ));
    $header_callus_phone_number      = get_theme_mod('dogri_header_callus_number', esc_html__( '(+800) 1234 5678 90', 'dogri' ));

    ?>
    

    <!-- search area start -->
   <div class="df-search-area">
      <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="df-search-form">
                  <div class="df-search-close text-center mb-20">
                     <button class="df-search-close-btn df-search-close-btn"></button>
                  </div>
                  <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                     <div class="df-search-input mb-10">
                     <input type="search" class="form-control" name="s"
                            placeholder="<?php echo esc_attr_x( 'Type your keyword and hit', 'placeholder', 'dogri' ); ?>" value="<?php echo get_search_query(); ?>">
                        <button type="submit"><?php echo _x( '<i class="flaticon-search-1"></i>', 'submit button', 'dogri' ); ?></button>
                     </div>
                     <div class="df-search-category">
                        <!-- <span>Search by : </span>
                        <a href="#">Healthline, </a>
                        <a href="#">COVID-19, </a>
                        <a href="#">Surgery, </a>
                        <a href="#">Surgeon, </a>
                        <a href="#">Medical research</a> -->
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- search area end -->

   <!-- Header area start -->
   <header>
      <div id="header-sticky" class="header-area header-2 header-transparent">
         <div class="container-fluid">
            <div class="mega-menu-wrapper">
               <div class="header-main">
                  <div class="header-left">
                     <div class="header-logo">
                        <?php dogri_header_logo(); ?>
                     </div>
                     <div class="mean__menu-wrapper d-none d-lg-block">
                        <div class="main-menu">
                            <!-- header menu area start -->
                                <?php dogri_header_menu(); ?>                             
                            <!-- header menu area end -->   
                           <!-- for wp -->
                           <div class="header__hamburger ml-50 d-none">
                              <button type="button" class="hamburger-btn offcanvas-open-btn">
                                 <span>01</span>
                                 <span>01</span>
                                 <span>01</span>
                              </button>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="header-right d-flex justify-content-end">
                     <div class="header-action d-none d-xl-inline-flex gap-5">
                        <?php 
                        if( $dogri_show_header_callus ): ?>
                        <div class="link-text">
                           <span><img src="<?php echo esc_url( $phone_icon ); ?>" alt="phone-icon"></span>
                           <a href="tel:<?php echo esc_attr( $header_phone_number ); ?>"><?php echo esc_html( $header_phone_number ); ?></a>
                        </div>
                        <?php 
                        endif; ?>
                        <?php 
                        if( $dogri_show_header_button ): ?>
                        <div class="header-link">
                           <a href="<?php echo esc_attr( $btn_link ); ?>" class="fill-btn">
                              <span class="fill-btn-inner">
                                 <span class="fill-btn-normal"><?php echo esc_html( $btn_text ); ?></span>
                                 <span class="fill-btn-hover"><?php echo esc_html( $btn_text ); ?></span>
                              </span>
                           </a>
                        </div>
                        <?php 
                        endif; ?>
                     </div>
                     <div class="header__hamburger d-xl-none">
                        <div class="sidebar__toggle">
                           <a class="bar-icon" href="javascript:void(0)">
                              <span></span>
                              <span>
                                 <small></small>
                              </span>
                              <span></span>
                           </a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </header>
   <!-- Header area end -->
   <?php echo dogri_header_extra(); ?>

<?php 
}


/**
* header style 2 
*/
function dogri_header_style_2() {

    $dogri_topbar_switch      = get_theme_mod('dogri_topbar_switch', false);
    $dogri_show_header_button = get_theme_mod('dogri_show_header_button', false);
    $btn_text_from_page         = get_post_meta(get_the_ID(), 'button_text_from_page', true);
    // $signup_page_link   = get_theme_mod('dogri_signup_page_link', '#'); 
    $phone_icon = get_template_directory_uri() . '/img/svg/phone-call.svg';
	$dogri_phone_icon = get_theme_mod('phone_icon', $phone_icon);

    if( $btn_text_from_page ){
        $btn_text               = get_post_meta(get_the_ID(), 'button_text_from_page', true);
        $btn_link               = get_post_meta(get_the_ID(), 'button_url_from_page', true);
    }else{
        $btn_text               = get_theme_mod('dogri_header_btn_text', esc_html__( 'Get A Quote', 'dogri' ));
        $btn_link               = get_theme_mod('dogri_header_btn_link', '#');
    }

    $header_contact_address     = get_theme_mod('dogri_header_contact_address', esc_html__( '8302 Preston Rd. Maine 9380', 'dogri' ));
    $header_contact_email       = get_theme_mod('dogri_header_contact_email', esc_html__( 'hello@dogri.com', 'dogri' ));
    $header_contact_phone               = get_theme_mod('dogri_header_contact_phone', esc_html__('+123-456-7890', 'dogri'));

    // $header_top_menu_one        = get_theme_mod('dogri_header_top_menu_one', esc_html__( 'FAQ', 'dogri' ));
    // $header_top_menu_one_link   = get_theme_mod('dogri_header_top_menu_one_link', '#'); 
    // $header_top_menu_two        = get_theme_mod('dogri_header_top_menu_two', esc_html__( 'Help', 'dogri' ));
    // $header_top_menu_two_link   = get_theme_mod('dogri_header_top_menu_two_link', '#');
    // $header_top_menu_three      = get_theme_mod('dogri_header_top_menu_three', esc_html__( 'Contact', 'dogri' ));
    // $header_top_menu_three_link   = get_theme_mod('dogri_header_top_menu_three_link', '#');

    $show_social_profiles       = get_theme_mod('dogri_header_social_profiles', true);

    $dogri_show_header_callus = get_theme_mod('dogri_show_header_callus', false);
    $header_phone_number      = get_theme_mod('dogri_header_callus', esc_html__( '+380961381876', 'dogri' ));
    $header_callus_phone_number      = get_theme_mod('dogri_header_callus_number', esc_html__( '(+800) 1234 5678 90', 'dogri' ));

    ?>

    <!-- search area start -->
    <div class="df-search-area">
      <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="df-search-form">
                  <div class="df-search-close text-center mb-20">
                     <button class="df-search-close-btn df-search-close-btn"></button>
                  </div>
                  <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                     <div class="df-search-input mb-10">
                     <input type="search" class="form-control" name="s"
                            placeholder="<?php echo esc_attr_x( 'Type your keyword and hit', 'placeholder', 'dogri' ); ?>" value="<?php echo get_search_query(); ?>">
                        <button type="submit"><?php echo _x( '<i class="flaticon-search-1"></i>', 'submit button', 'dogri' ); ?></button>
                     </div>
                     <div class="df-search-category">
                        <!-- <span>Search by : </span>
                        <a href="#">Healthline, </a>
                        <a href="#">COVID-19, </a>
                        <a href="#">Surgery, </a>
                        <a href="#">Surgeon, </a>
                        <a href="#">Medical research</a> -->
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- search area end -->

   <!-- Header area start -->
   <header>
      <div id="header-sticky" class="header-area">
         <div class="container-fluid">
            <div class="mega-menu-wrapper">
               <div class="header-main">
                  <div class="header-left">
                     <div class="header-logo">
                        <?php dogri_header_logo(); ?>
                     </div>
                     <div class="mean__menu-wrapper d-none d-lg-block">
                        <div class="main-menu">
                           <!-- header menu area start -->
                           <?php dogri_header_menu(); ?>                             
                            <!-- header menu area end --> 
                           <!-- for wp -->
                           <div class="header__hamburger ml-50 d-none">
                              <button type="button" class="hamburger-btn offcanvas-open-btn">
                                 <span>01</span>
                                 <span>01</span>
                                 <span>01</span>
                              </button>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="header-right d-flex align-items-center justify-content-end ">
                     <div class="header-action d-none d-lg-inline-flex gap-5 ">
                        <?php 
                        if( $dogri_show_header_callus ): ?>
                        <div class="link-text d-none d-xxl-block">
                           <span><img src="<?php echo esc_url( $phone_icon ); ?>" alt=""></span>
                           <span><a href="tel:+<?php echo esc_attr( $header_phone_number ); ?>"><?php echo esc_html( $header_phone_number ); ?></a></span>
                        </div>
                        <?php 
                        endif; ?>
                        <div class="header-quick-access d-flex align-items-center">
                           <button class="search-toggle-open header-search">
                              <span>
                                 <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M17.125 16.75L21.625 21.25" stroke="white" stroke-width="2"
                                       stroke-linecap="round" stroke-linejoin="round" />
                                    <path
                                       d="M19.375 10C19.375 14.9706 15.3456 19 10.375 19C5.40443 19 1.375 14.9706 1.375 10C1.375 5.02943 5.40443 1 10.375 1C15.3456 1 19.375 5.02943 19.375 10Z"
                                       stroke="white" stroke-width="2" />
                                 </svg>
                              </span>
                           </button>
                           <div class="divider-line"></div>
                           <div class="header__hamburger">
                              <div class="sidebar__toggle">
                                 <a class="bar-icon is-white" href="javascript:void(0)">
                                    <span></span>
                                    <span>
                                       <small></small>
                                    </span>
                                    <span></span>
                                 </a>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="header__hamburger d-lg-none">
                     <div class="sidebar__toggle">
                        <a class="bar-icon" href="javascript:void(0)">
                           <span></span>
                           <span>
                              <small></small>
                           </span>
                           <span></span>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </header>
   <!-- Header area end -->

   <?php echo dogri_header_extra(); ?>


<?php 
}


/**
* header style 3
*/
function dogri_header_style_3() {

    $dogri_topbar_switch      = get_theme_mod('dogri_topbar_switch', false);
    $dogri_show_header_button = get_theme_mod('dogri_show_header_button', false);
    $btn_text_from_page         = get_post_meta(get_the_ID(), 'button_text_from_page', true);
    // $signup_page_link   = get_theme_mod('dogri_signup_page_link', '#'); 
    $phone_icon_1 = get_template_directory_uri() . '/img/icons/call.png';
	$dogri_phone_icon = get_theme_mod('phone_icon_1', $phone_icon_1);

    if( $btn_text_from_page ){
        $btn_text               = get_post_meta(get_the_ID(), 'button_text_from_page', true);
        $btn_link               = get_post_meta(get_the_ID(), 'button_url_from_page', true);
    }else{
        $btn_text               = get_theme_mod('dogri_header_btn_text', esc_html__( 'Get A Quote', 'dogri' ));
        $btn_link               = get_theme_mod('dogri_header_btn_link', '#');
    }

    $header_contact_address     = get_theme_mod('dogri_header_contact_address', esc_html__( '8302 Preston Rd. Maine 9380', 'dogri' ));
    $header_contact_email       = get_theme_mod('dogri_header_contact_email', esc_html__( 'hello@dogri.com', 'dogri' ));
    $header_contact_phone               = get_theme_mod('dogri_header_contact_phone', esc_html__('+123-456-7890', 'dogri'));

    // $header_top_menu_one        = get_theme_mod('dogri_header_top_menu_one', esc_html__( 'FAQ', 'dogri' ));
    // $header_top_menu_one_link   = get_theme_mod('dogri_header_top_menu_one_link', '#'); 
    // $header_top_menu_two        = get_theme_mod('dogri_header_top_menu_two', esc_html__( 'Help', 'dogri' ));
    // $header_top_menu_two_link   = get_theme_mod('dogri_header_top_menu_two_link', '#');
    // $header_top_menu_three      = get_theme_mod('dogri_header_top_menu_three', esc_html__( 'Contact', 'dogri' ));
    // $header_top_menu_three_link   = get_theme_mod('dogri_header_top_menu_three_link', '#');

    $show_social_profiles       = get_theme_mod('dogri_header_social_profiles', true);

    $dogri_show_header_callus = get_theme_mod('dogri_show_header_callus', false);
    $header_phone_number_1      = get_theme_mod('dogri_header_callus_1', esc_html__( '+380961381876', 'dogri' ));
    $header_callus_phone_number      = get_theme_mod('dogri_header_callus_number', esc_html__( '(+800) 1234 5678 90', 'dogri' ));

    ?>

    <!-- search area start -->
    <div class="df-search-area">
      <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="df-search-form">
                  <div class="df-search-close text-center mb-20">
                     <button class="df-search-close-btn df-search-close-btn"></button>
                  </div>
                  <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                     <div class="df-search-input mb-10">
                     <input type="search" class="form-control" name="s"
                            placeholder="<?php echo esc_attr_x( 'Type your keyword and hit', 'placeholder', 'dogri' ); ?>" value="<?php echo get_search_query(); ?>">
                        <button type="submit"><?php echo _x( '<i class="flaticon-search-1"></i>', 'submit button', 'dogri' ); ?></button>
                     </div>
                     <div class="df-search-category">
                        <!-- <span>Search by : </span>
                        <a href="#">Healthline, </a>
                        <a href="#">COVID-19, </a>
                        <a href="#">Surgery, </a>
                        <a href="#">Surgeon, </a>
                        <a href="#">Medical research</a> -->
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- search area end -->

    <!-- Header area start -->
    <header>
      <div id="header-sticky" class="header-area header-2">
         <div class="container-fluid">
            <div class="mega-menu-wrapper">
               <div class="header-main-3">
                  <div class="header-left">
                     <a class="sidebar__toggle" href="javascript:void(0)">
                        <div class="bar-icon-2">
                           <span></span>
                           <span></span>
                           <span></span>
                        </div>
                     </a>
                     <!-- for wp -->
                     <div class="header__hamburger ml-50 d-none">
                        <button type="button" class="hamburger-btn offcanvas-open-btn">
                           <span>01</span>
                           <span>01</span>
                           <span>01</span>
                        </button>
                     </div>
                     <div class="mean__menu-wrapper d-none d-lg-block">
                        <div class="main-menu">
                            <!-- header menu area start -->
                            <?php dogri_header_menu(); ?>                             
                            <!-- header menu area end --> 
                        </div>
                     </div>
                  </div>
                  <div class="header__middle d-lg-none d-xl-block">
                     <div class="header-logo">
                        <?php dogri_header_logo(); ?>
                     </div>
                  </div>
                  <div class="header-right-3 d-none d-md-inline-flex justify-content-end">
                     <div class="header-contact-info d-none d-lg-inline-flex">
                        <div class="header-contact-icon">
                        <img src="<?php echo esc_url( $phone_icon_1 ); ?>" alt="phone-icon">
                        </div>
                        <?php 
                        if( $dogri_show_header_callus ): ?>
                        <div class="header-contact-text">
                           <span>Call us now!</span>
                           <h6><a href="tel:<?php echo esc_attr( $header_phone_number_1 ); ?>"><?php echo esc_html( $header_phone_number_1 ); ?></a></h6>
                        </div>
                        <?php 
                        endif; ?>
                     </div>
                     <?php 
                    if( $dogri_show_header_button ): ?>
                     <div class="header-btn d-none d-md-block">
                        <a class="border-btn" href="<?php echo esc_attr( $btn_link ); ?>"><?php echo esc_html( $btn_text ); ?></a>
                     </div>
                     <?php 
                    endif; ?>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </header>
   <!-- Header area end -->

<?php echo dogri_header_extra(); ?>


<?php 
}



/**
* header style 4
*/
function dogri_header_style_4() {

    $dogri_topbar_switch      = get_theme_mod('dogri_topbar_switch', false);
    $dogri_show_header_button = get_theme_mod('dogri_show_header_button', false);
    $btn_text_from_page         = get_post_meta(get_the_ID(), 'button_text_from_page', true);
    // $signup_page_link   = get_theme_mod('dogri_signup_page_link', '#'); 
    $phone_icon_1 = get_template_directory_uri() . '/img/icons/call.png';
	$dogri_phone_icon = get_theme_mod('phone_icon_1', $phone_icon_1);

    if( $btn_text_from_page ){
        $btn_text               = get_post_meta(get_the_ID(), 'button_text_from_page', true);
        $btn_link               = get_post_meta(get_the_ID(), 'button_url_from_page', true);
    }else{
        $btn_text               = get_theme_mod('dogri_header_btn_text', esc_html__( 'Get A Quote', 'dogri' ));
        $btn_link               = get_theme_mod('dogri_header_btn_link', '#');
    }

    $header_contact_address     = get_theme_mod('dogri_header_contact_address', esc_html__( '8302 Preston Rd. Maine 9380', 'dogri' ));
    $header_contact_email       = get_theme_mod('dogri_header_contact_email', esc_html__( 'hello@dogri.com', 'dogri' ));
    $header_contact_phone               = get_theme_mod('dogri_header_contact_phone', esc_html__('+123-456-7890', 'dogri'));

    // $header_top_menu_one        = get_theme_mod('dogri_header_top_menu_one', esc_html__( 'FAQ', 'dogri' ));
    // $header_top_menu_one_link   = get_theme_mod('dogri_header_top_menu_one_link', '#'); 
    // $header_top_menu_two        = get_theme_mod('dogri_header_top_menu_two', esc_html__( 'Help', 'dogri' ));
    // $header_top_menu_two_link   = get_theme_mod('dogri_header_top_menu_two_link', '#');
    // $header_top_menu_three      = get_theme_mod('dogri_header_top_menu_three', esc_html__( 'Contact', 'dogri' ));
    // $header_top_menu_three_link   = get_theme_mod('dogri_header_top_menu_three_link', '#');

    $show_social_profiles       = get_theme_mod('dogri_header_social_profiles', true);

    $dogri_show_header_callus = get_theme_mod('dogri_show_header_callus', false);
    $header_phone_number_1      = get_theme_mod('dogri_header_callus_1', esc_html__( '+380961381876', 'dogri' ));
    $header_callus_phone_number      = get_theme_mod('dogri_header_callus_number', esc_html__( '(+800) 1234 5678 90', 'dogri' ));

    ?>

    <!-- search area start -->
    <div class="df-search-area">
      <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="df-search-form">
                  <div class="df-search-close text-center mb-20">
                     <button class="df-search-close-btn df-search-close-btn"></button>
                  </div>
                  <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                     <div class="df-search-input mb-10">
                     <input type="search" class="form-control" name="s"
                            placeholder="<?php echo esc_attr_x( 'Type your keyword and hit', 'placeholder', 'dogri' ); ?>" value="<?php echo get_search_query(); ?>">
                        <button type="submit"><?php echo _x( '<i class="flaticon-search-1"></i>', 'submit button', 'dogri' ); ?></button>
                     </div>
                     <div class="df-search-category">
                        <!-- <span>Search by : </span>
                        <a href="#">Healthline, </a>
                        <a href="#">COVID-19, </a>
                        <a href="#">Surgery, </a>
                        <a href="#">Surgeon, </a>
                        <a href="#">Medical research</a> -->
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- search area end -->

   <!-- Header area start -->
   <header>
      <div id="header-sticky" class="header-area header-4">
         <div class="mega-menu-wrapper">
            <div class="header-main-5">
               <div class="header-left">
                  <div class="header-logo">
                    <?php dogri_header_logo(); ?>
                  </div>
               </div>
               <div class="mean__menu-wrapper d-none d-lg-block">
                  <div class="main-menu">
                    <!-- header menu area start -->
                    <?php dogri_header_menu(); ?>                             
                    <!-- header menu area end --> 
                  </div>
               </div>
               <div class="header-right d-inline-flex justify-content-end">
                  <div class="link-text d-none d-xxl-block">
                    <?php 
                        if( $dogri_show_header_callus ): ?>
                     <span><img src="<?php echo esc_url( $phone_icon_1 ); ?>" alt="phone-icon"></span>
                     <a href="tel:<?php echo esc_attr( $header_phone_number_1 ); ?>"><?php echo esc_html( $header_phone_number_1 ); ?></a>
                     <?php 
                        endif; ?>
                  </div>
                  <div class="header-humbager ml-30">
                     <a class="sidebar__toggle" href="javascript:void(0)">
                        <div class="bar-icon-2">
                           <span></span>
                           <span></span>
                           <span></span>
                        </div>
                     </a>
                     <!-- for wp -->
                     <div class="header__hamburger ml-50 d-none">
                        <button type="button" class="hamburger-btn offcanvas-open-btn">
                           <span>01</span>
                           <span>01</span>
                           <span>01</span>
                        </button>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </header>
   <!-- Header area end -->


<?php echo dogri_header_extra(); ?>


<?php 
}


/**
* header style 5
*/
function dogri_header_style_5() {

    $dogri_topbar_switch      = get_theme_mod('dogri_topbar_switch', false);
    $dogri_show_header_button = get_theme_mod('dogri_show_header_button', false);
    $btn_text_from_page         = get_post_meta(get_the_ID(), 'button_text_from_page', true);
    // $signup_page_link   = get_theme_mod('dogri_signup_page_link', '#'); 
    $phone_icon_1 = get_template_directory_uri() . '/img/icons/call.png';
	$dogri_phone_icon = get_theme_mod('phone_icon_1', $phone_icon_1);

    if( $btn_text_from_page ){
        $btn_text               = get_post_meta(get_the_ID(), 'button_text_from_page', true);
        $btn_link               = get_post_meta(get_the_ID(), 'button_url_from_page', true);
    }else{
        $btn_text               = get_theme_mod('dogri_header_btn_text', esc_html__( 'Get A Quote', 'dogri' ));
        $btn_link               = get_theme_mod('dogri_header_btn_link', '#');
    }

    $header_contact_address     = get_theme_mod('dogri_header_contact_address', esc_html__( '8302 Preston Rd. Maine 9380', 'dogri' ));
    $header_contact_email       = get_theme_mod('dogri_header_contact_email', esc_html__( 'hello@dogri.com', 'dogri' ));
    $header_contact_phone               = get_theme_mod('dogri_header_contact_phone', esc_html__('+123-456-7890', 'dogri'));

    // $header_top_menu_one        = get_theme_mod('dogri_header_top_menu_one', esc_html__( 'FAQ', 'dogri' ));
    // $header_top_menu_one_link   = get_theme_mod('dogri_header_top_menu_one_link', '#'); 
    // $header_top_menu_two        = get_theme_mod('dogri_header_top_menu_two', esc_html__( 'Help', 'dogri' ));
    // $header_top_menu_two_link   = get_theme_mod('dogri_header_top_menu_two_link', '#');
    // $header_top_menu_three      = get_theme_mod('dogri_header_top_menu_three', esc_html__( 'Contact', 'dogri' ));
    // $header_top_menu_three_link   = get_theme_mod('dogri_header_top_menu_three_link', '#');

    $show_social_profiles       = get_theme_mod('dogri_header_social_profiles', true);

    $dogri_show_header_callus = get_theme_mod('dogri_show_header_callus', false);
    $header_phone_number_1      = get_theme_mod('dogri_header_callus_1', esc_html__( '+380961381876', 'dogri' ));
    $header_callus_phone_number      = get_theme_mod('dogri_header_callus_number', esc_html__( '(+800) 1234 5678 90', 'dogri' ));

    ?>

    <!-- search area start -->
    <div class="df-search-area">
      <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="df-search-form">
                  <div class="df-search-close text-center mb-20">
                     <button class="df-search-close-btn df-search-close-btn"></button>
                  </div>
                  <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                     <div class="df-search-input mb-10">
                     <input type="search" class="form-control" name="s"
                            placeholder="<?php echo esc_attr_x( 'Type your keyword and hit', 'placeholder', 'dogri' ); ?>" value="<?php echo get_search_query(); ?>">
                        <button type="submit"><?php echo _x( '<i class="flaticon-search-1"></i>', 'submit button', 'dogri' ); ?></button>
                     </div>
                     <div class="df-search-category">
                        <!-- <span>Search by : </span>
                        <a href="#">Healthline, </a>
                        <a href="#">COVID-19, </a>
                        <a href="#">Surgery, </a>
                        <a href="#">Surgeon, </a>
                        <a href="#">Medical research</a> -->
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- search area end -->

      <!-- Header area start -->
    <header>
      <div id="header-sticky" class="header-area header-5 header-transparent">
         <div class="mega-menu-wrapper">
            <div class="header-main-5">
               <div class="header-left">
                  <div class="header-logo">
                    <?php dogri_header_logo(); ?>
                  </div>
               </div>
               <div class="mean__menu-wrapper d-none d-lg-block">
                  <div class="main-menu main-menu-2">
                    <!-- header menu area start -->
                    <?php dogri_header_menu_2(); ?>                             
                    <!-- header menu area end --> 
                  </div>
               </div>
               <div class="header-right d-inline-flex justify-content-end">
                  <div class="header-right-action d-flex align-items-center">
                     <div class="header-btn d-none d-sm-block">
                        <?php 
                        if( $dogri_show_header_button ): ?>
                           <a href="<?php echo esc_attr( $btn_link ); ?>" class="fill-btn secondary">
                              <span class="fill-btn-inner">
                                 <span class="fill-btn-normal"><?php echo esc_html( $btn_text ); ?></span>
                                 <span class="fill-btn-hover"><?php echo esc_html( $btn_text ); ?></span>
                              </span>
                           </a>
                        <?php 
                        endif; ?>
                     </div>
                     <div class="header-humbager ml-30">
                        <a class="sidebar__toggle" href="javascript:void(0)">
                           <div class="bar-icon-2 is-white">
                              <span></span>
                              <span></span>
                              <span></span>
                           </div>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </header>
   <!-- Header area end -->


<?php echo dogri_header_extra(); ?>


<?php 
}


function dogri_header_menu_contact_box(){
    $show_header_menu_contact_info       = get_theme_mod('dogri_show_header_menu_contact_info', false);
    $header_menu_contact_info            = get_theme_mod('dogri_header_menu_contact_info', esc_html__( 'Got A Question?', 'dogri' ));
    $header_menu_contact_phone_number    = get_theme_mod('dogri_header_menu_contact_phone_number', esc_html__('+123-456-7890', 'dogri'));
    ob_start(); ?>

    <?php 
    if( $show_header_menu_contact_info ): ?>
        <div class="header-btn">
            <div class="icon-wrapper">
                <div class="icon">
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/img/icon/phone.png" alt="phone" />
                </div>
            </div>
            <div class="content-wrapper">
                <?php 
                if( $header_menu_contact_info !== ""): ?>
                    <span class="title"><?php echo esc_html( $header_menu_contact_info ); ?></span>
                <?php
                endif; ?>

                <?php 
                if( $header_menu_contact_phone_number !== ""): ?>
                    <span class="text"><a href="tel: <?php echo esc_attr( $header_menu_contact_phone_number ); ?>"><?php echo esc_html( $header_menu_contact_phone_number ); ?></a></span>
                <?php
                endif; ?>
            </div>
        </div>
    <?php
    endif; ?>

    <?php return ob_get_clean();
}


// header logo
function dogri_header_logo() {
    ?>
        <?php 
        $dogri_logo_on = get_post_meta(get_the_ID(), 'dogri_enable_sec_logo', true);
        $dogri_logo = get_template_directory_uri() . '/img/logo/logo.svg';
        $dogri_default_sticky_logo = get_template_directory_uri() . '/img/logo/logo-white.svg';
        $dogri_logo_white = get_template_directory_uri() . '/img/logo/logo-white.svg';

        $dogri_retina_logo = get_template_directory_uri().'/img/logo/logo@2x.svg';
        $dogri_retina_logo_white = get_template_directory_uri().'/img/logo/logo-white@2x.svg';

        $dogri_retina_logo  = get_theme_mod('retina_logo',$dogri_retina_logo);
        $dogri_retina_logo_white  = get_theme_mod('retina_secondary_logo',$dogri_retina_logo_white);

        $dogri_site_logo = get_theme_mod('logo', $dogri_logo);
        $dogri_sticky_logo = get_theme_mod('sticky_logo', $dogri_default_sticky_logo);
        $dogri_secondary_logo = get_theme_mod('seconday_logo', $dogri_logo_white);
        ?>
            
        <?php
        if( has_custom_logo()){
            the_custom_logo();
        }else{
            
            if($dogri_logo_on === 'on') { ?>
                <a class="standard-logo" href="<?php echo esc_url( home_url('/')); ?>">
                    <img src="<?php echo esc_url($dogri_secondary_logo); ?>" alt="<?php echo esc_attr('Logo','dogri'); ?>" />
                </a>
                <a class="retina-logo" href="<?php echo esc_url( home_url('/')); ?>">
                    <img src="<?php echo esc_url($dogri_retina_logo_white); ?>" alt="<?php echo esc_attr('Logo','dogri'); ?>" />
                </a>
                <a class="sticky-logo" href="<?php echo esc_url( home_url('/')); ?>" >
                    <img src="<?php echo esc_url( $dogri_sticky_logo ); ?>" alt="<?php echo esc_attr(' Sticky Logo','dogri'); ?>">
                </a>
            <?php 
            }
            else{ ?>
                <a class="standard-logo" href="<?php echo esc_url( home_url('/')); ?>">
                    <img src="<?php echo esc_url($dogri_site_logo); ?>" alt="<?php echo esc_attr('logo','dogri'); ?>" />
                </a>
                <a class="retina-logo" href="<?php echo esc_url( home_url('/')); ?>">
                    <img src="<?php echo esc_url($dogri_retina_logo); ?>" alt="<?php echo esc_attr('logo','dogri'); ?>" />
                </a>
                <a class="sticky-logo" href="<?php echo esc_url( home_url('/')); ?>" >
                    <img src="<?php echo esc_url( $dogri_sticky_logo ); ?>" alt="<?php echo esc_attr(' Sticky Logo','dogri'); ?>">
                </a>
            <?php 
            }
        }   
        ?>
    <?php 
} 

/** 
 * [dogri_header_social_profiles description]
 * @return [type] [description]
 */
function dogri_header_social_profiles() {
    $dogri_topbar_fb_url             = get_theme_mod('dogri_topbar_fb_url', '#');
    $dogri_topbar_twitter_url       = get_theme_mod('dogri_topbar_twitter_url', '#');
    $dogri_topbar_linkedin_url      = get_theme_mod('dogri_topbar_linkedin_url', '#');
    $dogri_topbar_youtube_url        = get_theme_mod('dogri_topbar_youtube_url', '#');
    ?>
        <?php if ($dogri_topbar_fb_url != '#'): ?>
          <li><a href="<?php echo esc_url($dogri_topbar_fb_url); ?>"><i class="fab fa-facebook-f"></i></a></li>
        <?php endif; ?>

        <?php if ($dogri_topbar_twitter_url != '#'): ?>
          <li><a href="<?php echo esc_url($dogri_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a></li>
        <?php endif; ?>

        <?php if ($dogri_topbar_linkedin_url != '#'): ?>
            <li><a href="<?php echo esc_url($dogri_topbar_linkedin_url); ?>"><i class="fab fa-linkedin-in"></i></a></li>
        <?php endif; ?>

        <?php if ($dogri_topbar_youtube_url != '#'): ?>
            <li><a href="<?php echo esc_url($dogri_topbar_youtube_url); ?>"><i class="fab fa-youtube"></i></a></li>
        <?php endif; ?>
<?php 
}

/** 
 * [dogri_header_menu menu]
 * @return [type] [menu]
 */


 register_nav_menus(array(
    'main-menu' => esc_html__('Main Menu', 'dogri'),
    'main-menu-2' => esc_html__('Main Menu Two', 'dogri'),
    'footer-menu' => esc_html__('Footer Menu', 'dogri'),
));

function dogri_header_menu() { ?>
    <nav id="main-menu" class="main-menu">
            <?php 
            wp_nav_menu(array(
                'theme_location'    => 'main-menu',
                'menu_class'        => '',
                'container'         => '',
                'fallback_cb'       => 'Dogri_Navwalker::fallback',
                'walker'            => new Dogri_Navwalker
            ));
           ?>
    </nav>
    <?php 
}

function dogri_header_menu_2() { ?>
    <nav id="main-menu" class="main-menu">
            <?php 
            wp_nav_menu(array(
                'theme_location'    => 'main-menu-2',
                'menu_class'        => '',
                'container'         => '',
                'fallback_cb'       => 'Dogri_Navwalker::fallback',
                'walker'            => new Dogri_Navwalker
            ));
           ?>
    </nav>
    <?php 
}

/** 
 * [dogri_header_menu footer menu]
 * @return [type] [footer menu]
 */
function dogri_footer_menu() { 
    
    wp_nav_menu(array(
        'theme_location'    => 'footer-menu',
        'menu_class'        => '',
        'container'         => '',
        'fallback_cb'       => 'Dogri_Navwalker::fallback',
        'walker'            => new Dogri_Navwalker
    ));
 
}

/**
*
* dogri footer
*/
add_action('dogri_footer_style', 'dogri_check_footer', 10);

function dogri_check_footer() {
    $dogri_footer_style = get_post_meta( get_the_ID(), 'dogri_choice_footer_style', true );
    $dogri_default_footer_style = get_theme_mod('choose_default_footer', 'footer-style-1' );
   

    if( $dogri_footer_style == 'footer-style-1' ) {
        dogri_footer_style_1();
    }
    elseif( $dogri_footer_style == 'footer-style-2' ) {
        dogri_footer_style_2();
    }
    elseif( $dogri_footer_style == 'footer-style-3' ) {
        dogri_footer_style_3();
    }
    elseif( $dogri_footer_style == 'footer-style-4' ) {
        dogri_footer_style_4();
    }
    else{

        /** default footer style **/
        if($dogri_default_footer_style == 'footer-style-1'){
            dogri_footer_style_1();
        }elseif($dogri_default_footer_style == 'footer-style-2'){
           dogri_footer_style_2();
        }elseif($dogri_default_footer_style == 'footer-style-3'){
           dogri_footer_style_3();
        }elseif($dogri_default_footer_style == 'footer-style-4'){
            dogri_footer_style_4();
         }

    }
}

/**
* footer  style 1 + default
*/
function dogri_footer_style_1() {

    $dogri_footer_bg_url_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    $dogri_footer_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    $dogri_footer_cr_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    $dogri_copyright_center =  has_nav_menu( 'footer-menu' ) ? 'col-xl-6 col-lg-6 col-md-6' : 'col-xl-12 col-lg-12 col-md-12 text-center';
    $default_footer = has_nav_menu( 'footer-menu' ) ? '' : ' default-style'; 

    $dogri_terms_option        = get_theme_mod('dogri_terms_option', esc_html__( 'Terms & Condition', 'dogri' ));
    $dogri_terms_option_link   = get_theme_mod('dogri_terms_option_link', '#'); 
    $dogri_privacy_policy_option       = get_theme_mod('dogri_privacy_policy_option', esc_html__( 'Privacy Policy', 'dogri' ));
    $dogri_privacy_policy_option_link   = get_theme_mod('dogri_privacy_policy_option_link', '#'); 


    if( $dogri_footer_bg_url_from_page ){
            $bg_img = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    }else{
            $bg_img = get_theme_mod('dogri_footer_bg');
    }  

    if( $dogri_footer_bg_color_from_page ){
            $bg_color = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    }else{
            $bg_color = get_theme_mod('dogri_footer_bg_color', '#191919');
    }      

    if( $dogri_footer_cr_bg_color_from_page ){
        $cr_bg_color = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    }else{
            $cr_bg_color = get_theme_mod('dogri_footer_cr_bg_color', '#ffffff00');
    } 

    ?>


   <!-- Footer area start -->
   <footer>
      <section class="footer-bg" style="background-color:<?php echo esc_attr( $bg_color ); ?>">
         <div class="footer-area">    
                <?php if ( in_array( 'dogri-toolkit/dogri-toolkit.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
                <div class="container">
                    <div class="footer-grid b-b">
                        <div class="footer-widget-2 footer-col-1">
                            <?php dynamic_sidebar('footer-widget-about-us-widget'); ?>
                        </div>
                        <div class="footer-widget-2 footer-col-2">
                            <div class="footer-link">
                                <?php dynamic_sidebar('footer-widget-links-widget'); ?>
                            </div>
                        </div>
                        <div class="footer-widget-2 footer-col-3">
                            <div class="footer-link">
                                <?php dynamic_sidebar('fws-2-er-second-widget'); ?>
                            </div>
                        </div>
                        <div class="footer-widget-2 footer-col-4">
                            <?php dynamic_sidebar('fws-2-er-fourth-widget'); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="footer-copyright-area">
                <div class="container">
                    <div class="footer-copyright-wrapper">
                        <div class="footer-copyright-text">
                            <p class="mb-0"><?php echo dogri_copyright_text(); ?></p>
                        </div>
                        <div class="footer-conditions">
                            <ul>
                                <li><a href="<?php echo esc_attr( $dogri_terms_option_link ); ?>"><?php echo esc_html( $dogri_terms_option ); ?></a></li>
                                <li><a href="<?php echo esc_attr( $dogri_privacy_policy_option_link ); ?>"><?php echo esc_html( $dogri_privacy_policy_option ); ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
      </section>
   </footer>
   <!-- Footer area end 1-->

<?php 
}

/**
* footer  style 2
*/
function dogri_footer_style_2() {

    $dogri_footer_bg_url_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    $dogri_footer_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    $dogri_footer_cr_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    $dogri_copyright_center =  has_nav_menu( 'footer-menu' ) ? 'col-xl-6 col-lg-6 col-md-6' : 'col-xl-12 col-lg-12 col-md-12 text-center';
    $default_footer = has_nav_menu( 'footer-menu' ) ? '' : ' default-style';

    // $dogri_footer_img = get_template_directory_uri() . '/img/footer/skyshape.png';
    $dogri_footer_img_2 = get_template_directory_uri() . '/img/footer/footer-bg.png';


    if( $dogri_footer_bg_url_from_page ){
            $bg_img = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    }else{
            $bg_img = get_theme_mod('dogri_footer_bg');
    }  

    if( $dogri_footer_bg_color_from_page ){
            $bg_color = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    }else{
            $bg_color = get_theme_mod('dogri_footer_bg_color', '#f8f9fa');
    }      

    if( $dogri_footer_cr_bg_color_from_page ){
        $cr_bg_color = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    }else{
            $cr_bg_color = get_theme_mod('dogri_footer_cr_bg_color', '#ffffff00');
    } 

    ?>


   <!-- Footer area start -->
   <footer>
      <div class="footer-area footer-bg section-space-medium">

        <?php if ( in_array( 'dogri-toolkit/dogri-toolkit.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
         <div class="container">
            <div class="row gy-50 justify-content-between">
               <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                    <?php dynamic_sidebar('fws-2-er-top-widget'); ?>
               </div>
               <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-6 col-sm-6">
                  <div class="footer-widget footer-col-2">
                     <div class="footer-link">
                        <?php dynamic_sidebar('footer-widget-links-widget'); ?>
                     </div>
                  </div>
               </div>
               <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
                  <div class="footer-widget footer-col-3">
                     <div class="footer-link">
                        <?php dynamic_sidebar('fws-2-er-second-widget'); ?>
                     </div>
                  </div>
               </div>
               <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
                  <div class="footer-widget footer-col-4">
                    <?php dynamic_sidebar('fws-2-er-fourth-widget-2'); ?>   
                  </div>
               </div>
            </div>
         </div>
         <?php endif; ?>

      </div>
      <div class="fotter-bottom theme-bg-1 pt-25 pb-25">
         <div class="footer-copyright-text text-center">
            <p class="mb-0"><?php echo dogri_copyright_text(); ?></p>
         </div>
      </div>
   </footer>
   <!-- Footer area end 2-->

<?php 
}

/**
* footer style 3
*/
function dogri_footer_style_3() {

    $dogri_footer_bg_url_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    $dogri_footer_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    $dogri_footer_cr_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    $dogri_copyright_center =  has_nav_menu( 'footer-menu' ) ? 'col-xl-6 col-lg-6 col-md-6' : 'col-xl-12 col-lg-12 col-md-12 text-center';
    $default_footer = has_nav_menu( 'footer-menu' ) ? '' : ' default-style'; 

    $dogri_terms_option        = get_theme_mod('dogri_terms_option', esc_html__( 'Terms & Condition', 'dogri' ));
    $dogri_terms_option_link   = get_theme_mod('dogri_terms_option_link', '#'); 
    $dogri_privacy_policy_option       = get_theme_mod('dogri_privacy_policy_option', esc_html__( 'Privacy Policy', 'dogri' ));
    $dogri_privacy_policy_option_link   = get_theme_mod('dogri_privacy_policy_option_link', '#'); 


    if( $dogri_footer_bg_url_from_page ){
            $bg_img = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    }else{
            $bg_img = get_theme_mod('dogri_footer_bg');
    }  

    if( $dogri_footer_bg_color_from_page ){
            $bg_color = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    }else{
            $bg_color = get_theme_mod('dogri_footer_bg_color', '#191919');
    }      

    if( $dogri_footer_cr_bg_color_from_page ){
        $cr_bg_color = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    }else{
            $cr_bg_color = get_theme_mod('dogri_footer_cr_bg_color', '#ffffff00');
    } 

    ?>

   <!-- Footer area start -->
   <footer>
      <div class="footer-style-3">
      <?php if ( in_array( 'dogri-toolkit/dogri-toolkit.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
         <div class="footer-area theme-bg-4 section-space-medium">
            <div class="container">
               <div class="footer-grid-3">
                    <div class="footer-widget-3">
                     <?php dynamic_sidebar('footer-widget-help-widget'); ?>
                    </div>
                  <div class="footer-widget-3">
                    <div class="footer-link">
                    <?php dynamic_sidebar('footer-widget-links-widget'); ?>
                    </div>
                  </div>
                  <div class="footer-widget-3">
                    <div class="footer-link">
                    <?php dynamic_sidebar('fws-2-er-second-widget'); ?>
                    </div>
                  </div>
                  <div class="footer-widget-3">
                     <div class="footer-working">                     
                     <?php dynamic_sidebar('footer-top-subscribe-widget'); ?>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php endif; ?>
         <div class="fotter-bottom theme-bg-1 pt-25 pb-25">
            <div class="container">
               <div class="footer-copyright-wrapper">
                  <div class="footer-copyright-text">
                     <p class="mb-0"><?php echo dogri_copyright_text(); ?></p>
                  </div>
                  <div class="footer-conditions">
                    <ul>
                        <li><a href="<?php echo esc_attr( $dogri_terms_option_link ); ?>"><?php echo esc_html( $dogri_terms_option ); ?></a></li>
                        <li><a href="<?php echo esc_attr( $dogri_privacy_policy_option_link ); ?>"><?php echo esc_html( $dogri_privacy_policy_option ); ?></a></li>
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </footer>
   <!-- Footer area end 3-->


<?php 
}


/**
* footer style 4
*/
function dogri_footer_style_4() {

    $dogri_footer_bg_url_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    $dogri_footer_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    $dogri_footer_cr_bg_color_from_page = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    $dogri_copyright_center =  has_nav_menu( 'footer-menu' ) ? 'col-xl-6 col-lg-6 col-md-6' : 'col-xl-12 col-lg-12 col-md-12 text-center';
    $default_footer = has_nav_menu( 'footer-menu' ) ? '' : ' default-style'; 

    $dogri_terms_option        = get_theme_mod('dogri_terms_option', esc_html__( 'Terms & Condition', 'dogri' ));
    $dogri_terms_option_link   = get_theme_mod('dogri_terms_option_link', '#'); 
    $dogri_privacy_policy_option       = get_theme_mod('dogri_privacy_policy_option', esc_html__( 'Privacy Policy', 'dogri' ));
    $dogri_privacy_policy_option_link   = get_theme_mod('dogri_privacy_policy_option_link', '#'); 


    if( $dogri_footer_bg_url_from_page ){
            $bg_img = get_post_meta( get_the_ID(), 'dogri_footer_bg', true );
    }else{
            $bg_img = get_theme_mod('dogri_footer_bg');
    }  

    if( $dogri_footer_bg_color_from_page ){
            $bg_color = get_post_meta( get_the_ID(), 'dogri_footer_bg_color', true );
    }else{
            $bg_color = get_theme_mod('dogri_footer_bg_color', '#191919');
    }      

    if( $dogri_footer_cr_bg_color_from_page ){
        $cr_bg_color = get_post_meta( get_the_ID(), 'dogri_footer_cr_bg_color', true );
    }else{
            $cr_bg_color = get_theme_mod('dogri_footer_cr_bg_color', '#ffffff00');
    } 

    ?>

      <!-- Footer area start -->
    <footer>
      <div class="footer-area theme-bg-4 section-space-medium-top">
         <div class="footer-style-5">
            <div class="container">
                <?php if ( in_array( 'dogri-toolkit/dogri-toolkit.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
               <div class="footer-grid-5">
                  <div class="footer-widget-5-1">
                    <?php dynamic_sidebar('footer-widget-help-widget'); ?>
                  </div>
                  <div class="footer-widget-5-2">
                    <div class="footer-link">
                        <?php dynamic_sidebar('footer-widget-links-widget'); ?>
                    </div>
                  </div>
                  <div class="footer-widget-5-3">
                    <div class="footer-link">
                        <?php dynamic_sidebar('fws-2-er-second-widget'); ?>
                    </div>
                  </div>
                  <div class="footer-widget-5-4">
                    <div class="footer-working"> 
                        <?php dynamic_sidebar('footer-top-subscribe-widget'); ?>
                    </div>
                  </div>
               </div>
               <?php endif; ?>
               <div class="footer-copyright-area">
                  <div class="container">
                     <div class="footer-copyright-wrapper">
                        <div class="footer-copyright-text">
                           <p class="mb-0"><?php echo dogri_copyright_text(); ?></p>
                        </div>
                        <div class="footer-conditions">
                           <ul>
                            <li><a href="<?php echo esc_attr( $dogri_terms_option_link ); ?>"><?php echo esc_html( $dogri_terms_option ); ?></a></li>
                            <li><a href="<?php echo esc_attr( $dogri_privacy_policy_option_link ); ?>"><?php echo esc_html( $dogri_privacy_policy_option ); ?></a></li>
                           </ul>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </footer>
   <!-- Footer area end -->


<?php 
}

function dogri_copyright_text(){
    return get_theme_mod('dogri_copyright', esc_html__('Copyright ©2023 Dogri. All Rights Reserved', 'dogri'));
}

add_action('dogri_before_main_content', 'dogri_check_breadcrumb');
function dogri_check_breadcrumb() {
    $dogri_breadcrumb_style = get_post_meta( get_the_ID(), 'dogri_choice_breadcrumb_style', true );
    $dogri_default_breadcrumb_style = get_theme_mod('choose_default_breadcrumb', 'breadcrumb-style-1' );

    if( $dogri_breadcrumb_style == 'breadcrumb-style-1' ) {
        dogri_breadcrumb_style_1();
    }
    elseif( $dogri_breadcrumb_style == 'breadcrumb-style-2' ) {
        dogri_breadcrumb_style_2();
    }
    else {
        
        /** default breadcrumb style **/
        if($dogri_default_breadcrumb_style == 'breadcrumb-style-1'){
            dogri_breadcrumb_style_1();
        }elseif($dogri_default_breadcrumb_style == 'breadcrumb-style-2'){
            dogri_breadcrumb_style_2();
        }
    }
}

/** 
 * [dogri_breadcrumb_style_1 description]
 * @return [type] [description]
 */
function dogri_breadcrumb_style_1() { 
    $dogri_invisible_breadcrumb = get_post_meta( get_the_ID(), 'dogri_invisible_breadcrumb', false );
    if( !$dogri_invisible_breadcrumb ) {

        $breadcrumb_img_from_page = get_post_meta(get_the_ID(), 'breadcrumb_bg_img_from_page', true);
        $hide_breadcrumb_bg_img = get_post_meta(get_the_ID(), 'hide_breadcrumb_bg_img', true); 

        $breadcrumb_img_from_page_shape_1 = get_post_meta(get_the_ID(), 'breadcrumb_bg_img_from_page_shape_1', true);
        $hide_breadcrumb_bg_img_shape_1 = get_post_meta(get_the_ID(), 'hide_breadcrumb_bg_img_shape_1', true); 

        $breadcrumb_img_from_page_shape_2 = get_post_meta(get_the_ID(), 'breadcrumb_bg_img_from_page_shape_2', true);
        $hide_breadcrumb_bg_img_shape_2 = get_post_meta(get_the_ID(), 'hide_breadcrumb_bg_img_shape_2', true); 
        $blog_page_title_img = get_template_directory_uri() . '/img/resources/page-title-5.jpg';
     
        // breadcrumb bg image
        if( empty($hide_breadcrumb_bg_img ) ){

            if( $breadcrumb_img_from_page ){
                    $bg_img = get_post_meta(get_the_ID(), 'breadcrumb_bg_img_from_page', true);
                    $bg_img = 'background-image :url('.$bg_img.')';
            }else{
                    $bg_img = get_theme_mod('breadcrumb_bg_img');
                    $bg_img = 'background-image :url('.$bg_img.')';
            }    
        }else{
            $bg_img = "";
        }

        
        // Shape-1

          if( empty($hide_breadcrumb_bg_img_shape_1 ) ){

            if( $breadcrumb_img_from_page_shape_1 ){
                    $bg_img_shape_1 = get_post_meta(get_the_ID(), 'breadcrumb_bg_img_from_page_shape_1', true);
                    $bg_img_shape_1 = 'background-image :url('.$bg_img_shape_1.')';
            }else{
                    $bg_img_shape_1 = get_theme_mod('breadcrumb_bg_img_shape_1');
                    $bg_img_shape_1 = 'background-image :url('.$bg_img_shape_1.')';
            }    
        }else{
            $bg_img_shape_1 = "";
        }

         // Shape-2

         if( empty($hide_breadcrumb_bg_img_shape_2 ) ){

            if( $breadcrumb_img_from_page_shape_2 ){
                    $bg_img_shape_2 = get_post_meta(get_the_ID(), 'breadcrumb_bg_img_from_page_shape_2', true);
                    $bg_img_shape_2 = 'background-image :url('.$bg_img_shape_2.')';
            }else{
                    $bg_img_shape_2 = get_theme_mod('breadcrumb_bg_img_shape_2');
                    $bg_img_shape_2 = 'background-image :url('.$bg_img_shape_2.')';
            }    
        }else{
            $bg_img_shape_2 = "";
        }
        
        $breadcrumb_blog_title = get_theme_mod('breadcrumb_blog_title', 'Blog ');
        $breadcrumb_blog_title_details = get_theme_mod('breadcrumb_blog_title_details', 'Blog Details');

        $dogri_blog_breadcrumb = get_theme_mod('dogri_blog_breadcrumb', '');
        if ( is_front_page() && is_home() ) { ?>
          
              <!-- Breadcrumb area start  -->
            <div class="breadcrumb__area theme-bg-1 p-relative z-index-11 pt-95 pb-95">
                <div class="breadcrumb__thumb" style="<?php echo esc_attr($bg_img); ?>"></div>
                <div class="container">
                    <div class="row justify-content-center">
                    <div class="col-xxl-12">
                        <div class="breadcrumb__wrapper text-center">
                            <h2 class="breadcrumb__title"><?php echo esc_html($breadcrumb_blog_title); ?></h2>
                            <div class="breadcrumb__menu">
                                <nav>
                                <ul>
                                    <li><span><a href="<?php echo  esc_url( home_url() ); ?>"><?php echo esc_html__( 'Home', 'dogri' ); ?></a></span></li>
                                    <li><span><?php echo esc_html__( 'Blog', 'dogri' ); ?></span></li>
                                </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- Breadcrumb area start  -->

        <?php   
        } elseif ( is_front_page()){?>
        <div class="breadcrumb-area breadcrumb-bg only-front-page breadcrumb-spacing">
        </div>
        <?php
        } elseif ( is_home()){ ?>
        <!-- blog grid -->

        <!-- Breadcrumb area start  -->
        <div class="breadcrumb__area theme-bg-1 p-relative z-index-11 pt-95 pb-95">
                <div class="breadcrumb__thumb" style="<?php echo esc_attr($bg_img); ?>"></div>
                <div class="container">
                    <div class="row justify-content-center">
                    <div class="col-xxl-12">
                        <div class="breadcrumb__wrapper text-center">
                            <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $dogri_blog_breadcrumb == '' ) { ?>
                                    <h2 class="breadcrumb__title"><?php echo esc_html($breadcrumb_blog_title_details); ?></h2>
                                <?php 
                                }
                                else { ?>
                                    <h2 class="breadcrumb__title"> <?php echo esc_html($dogri_blog_breadcrumb);?></h2>
                                <?php 
                                } ?>
                                
                                <?php 
                            }
                            else { ?>
                
                                    <h2 class="breadcrumb__title"><?php echo dogri_page_title(); ?></h2>
                            <?php 
                            } ?>
                            <div class="breadcrumb__menu">
                                <nav>
                                <ul>
                                    <?php dogri_breadcrumbs(); ?>
                                </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- Breadcrumb area start  -->



        <?php
        }
        elseif ( is_single() && 'dogri-service' == get_post_type() ) { ?>           

            <!-- Breadcrumb area start  -->
        <div class="breadcrumb__area theme-bg-1 p-relative z-index-11 pt-95 pb-95">
                <div class="breadcrumb__thumb" style="<?php echo esc_attr($bg_img); ?>"></div>
                <div class="container">
                    <div class="row justify-content-center">
                    <div class="col-xxl-12">
                        <div class="breadcrumb__wrapper text-center">
                            <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $dogri_blog_breadcrumb == '' ) { ?>
                                    <h2 class="breadcrumb__title"><?php echo esc_html($breadcrumb_blog_title_details); ?></h2>
                                <?php 
                                }
                                else { ?>
                                    <h2 class="breadcrumb__title"> <?php echo esc_html($dogri_blog_breadcrumb);?></h2>
                                <?php 
                                } ?>
                                
                                <?php 
                            }
                            else { ?>
                
                                    <h2 class="breadcrumb__title"><?php echo dogri_page_title(); ?></h2>
                            <?php 
                            } ?>
                            <div class="breadcrumb__menu">
                                <nav>
                                <ul>
                                    <?php dogri_breadcrumbs(); ?>
                                </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- Breadcrumb area start  -->


        <?php
        }
        elseif ( is_single() ) { ?>

            <!-- blog details -->        

            <!-- Breadcrumb area start  -->
        <div class="breadcrumb__area theme-bg-1 p-relative z-index-11 pt-95 pb-95">
                <div class="breadcrumb__thumb" style="<?php echo esc_attr($bg_img); ?>"></div>
                <div class="container">
                    <div class="row justify-content-center">
                    <div class="col-xxl-12">
                        <div class="breadcrumb__wrapper text-center">
                            <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $dogri_blog_breadcrumb == '' ) { ?>
                                    <h2 class="breadcrumb__title"><?php echo esc_html($breadcrumb_blog_title_details); ?></h2>
                                <?php 
                                }
                                else { ?>
                                    <h2 class="breadcrumb__title"> <?php echo esc_html($dogri_blog_breadcrumb);?></h2>
                                <?php 
                                } ?>
                                
                                <?php 
                            }
                            else { ?>
                
                                    <h2 class="breadcrumb__title"><?php echo dogri_page_title(); ?></h2>
                            <?php 
                            } ?>
                            <div class="breadcrumb__menu">
                                <nav>
                                <ul>
                                    <?php dogri_breadcrumbs(); ?>
                                </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- Breadcrumb area start  -->


        <?php
        }
        else { ?>       

         <!-- Breadcrumb area start  -->
        <div class="breadcrumb__area theme-bg-1 p-relative z-index-11 pt-95 pb-95">
                <div class="breadcrumb__thumb" style="<?php echo esc_attr($bg_img); ?>"></div>
                <div class="container">
                    <div class="row justify-content-center">
                    <div class="col-xxl-12">
                        <div class="breadcrumb__wrapper text-center">
                            <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $dogri_blog_breadcrumb == '' ) { ?>
                                    <h2 class="breadcrumb__title"><?php echo esc_html($breadcrumb_blog_title_details); ?></h2>
                                <?php 
                                }
                                else { ?>
                                    <h2 class="breadcrumb__title"> <?php echo esc_html($dogri_blog_breadcrumb);?></h2>
                                <?php 
                                } ?>
                                
                                <?php 
                            }
                            else { ?>
                
                                    <h2 class="breadcrumb__title"><?php echo dogri_page_title(); ?></h2>
                            <?php 
                            } ?>
                            <div class="breadcrumb__menu">
                                <nav>
                                <ul>
                                    <?php dogri_breadcrumbs(); ?>
                                </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- Breadcrumb area start  -->


        <?php
        }       
    }
}

if(!function_exists('dogri_breadcrumbs')) {

    function _dogri_home_callback($home) {
        return $home;
    }

    function _dogri_breadcrumbs_callback($breadcrumbs) {
        return $breadcrumbs;
    }

    function dogri_breadcrumbs() {
        global $post;

        $breadcrumb_archive = get_theme_mod('breadcrumb_archive','Archive for category ');
        $breadcrumb_search = get_theme_mod('breadcrumb_search','Search results for ');
        $breadcrumb_post_tags = get_theme_mod('breadcrumb_post_tags','Posts tagged ');
        $breadcrumb_artitle_post_by = get_theme_mod('breadcrumb_artitle_post_by','Articles posted by ');
        $breadcrumb_404 = get_theme_mod('breadcrumb_404','Page Not Found ');
        $breadcrumb_page = get_theme_mod('breadcrumb_page','Page ');
        $breadcrumb_home = get_theme_mod('breadcrumb_home','Home ');

        $home = '<li class="breadcrumb-list"><a href="'.esc_url( home_url('/')).'" title="'.esc_attr($breadcrumb_home).'">'.esc_html($breadcrumb_home).'</a></li>';
        $showCurrent = 1;               
        $homeLink = esc_url( home_url('/'));
        if ( is_front_page() ) { return; }  // don't display breadcrumbs on the homepage (yet)

        echo _dogri_home_callback($home);

        if ( is_category() ) {
            // category section
            $thisCat = get_category(get_query_var('cat'), false);
            if (!empty($thisCat->parent)) echo get_category_parents($thisCat->parent, TRUE, ' ' . '/' . ' ');
            echo '<li class="active">'.  esc_html($breadcrumb_archive).' "' . single_cat_title('', false) . '"' . '</li>';
        } 
        elseif ( is_search() ) {
            // search section
            echo '<li class="active">' .  esc_html($breadcrumb_search).' "' . get_search_query() . '"' .'</li>';
        } 
        elseif ( is_day() ) {
            echo '<li class="breadcrumb-list"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li>';
            echo '<li class="breadcrumb-list"><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> </li>';
            echo '<li class="active">' . get_the_time('d') .'</li>';
        } 
        elseif ( is_month() ) {
            // monthly archive
            echo '<li class="breadcrumb-list"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> </li>';
            echo '<li class=" active">' . get_the_time('F') .'</li>';
        } 
        elseif ( is_year() ) {
            // yearly archive
            echo '<li class="active">'. get_the_time('Y') .'</li>';
        } 
        elseif ( is_single() && !is_attachment() ) {
            // single post or page
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;
                echo '<li class="breadcrumb-list"><a href="' . $homeLink . '/?post_type=' . $slug['slug'] . '">' . $post_type->labels->singular_name . '</a></li>';
                if ($showCurrent) echo '<li class="active">'. get_the_title() .'</li>';
            } 
            else {
                $cat = get_the_category(); if (isset($cat[0])) {$cat = $cat[0];} else {$cat = false;}
                if ($cat) {$cats = get_category_parents($cat, TRUE, ' ' .' ' . ' ');} else {$cats=false;}
                if (!$showCurrent && $cats) $cats = preg_replace("#^(.+)\s\s$#", "$1", $cats);
                echo '<li class="breadcrumb-list">'.$cats.'</li>';
            }
        } 
        elseif ( is_attachment() ) {
            // attachment section
            $parent = get_post($post->post_parent);
            $cat = get_the_category($parent->ID); if (isset($cat[0])) {$cat = $cat[0];} else {$cat=false;}
            if ($cat) echo get_category_parents($cat, TRUE, ' ' . ' ' . ' ');
            echo '<li class="breadcrumb-list"><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li>';
        } 
        elseif ( is_page() && !$post->post_parent ) {

            // parent page
            if ($showCurrent) 
                echo '<li class="breadcrumb-list"><a href="' . get_permalink() . '">'. get_the_title() .'</a></li>';
        } 
        elseif ( is_page() && $post->post_parent ) {
            // child page
            $parent_id  = $post->post_parent;
            $breadcrumbs = array();

            while ($parent_id) {
                $page = get_page($parent_id);
                $breadcrumbs[] = '<li class="breadcrumb-list"><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
                $parent_id  = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            for ($i = 0; $i < count($breadcrumbs); $i++) {
                echo _dogri_breadcrumbs_callback($breadcrumbs[$i]);
                if ($i != count($breadcrumbs)-1);
            }
            if ($showCurrent) echo '<li class="active">'. get_the_title() .'</li>';
        } 
        elseif ( is_tag() ) {
            // tags archive
            echo '<li class="breadcrumb-list">' .  esc_html($breadcrumb_post_tags).' "' . single_tag_title('', false) . '"' . '</li>';
        } 
        elseif ( is_author() ) {
            // author archive 
            global $author;
            $userdata = get_userdata($author);
            echo '<li class="breadcrumb-list">' .  esc_html($breadcrumb_artitle_post_by). ' ' . $userdata->display_name . '</li>';
        } 
        elseif ( is_404() ) {
            // 404
            echo '<li class="active">'. esc_html($breadcrumb_404) .'</li>';
        }
      
        if ( get_query_var('paged') ) {
            
            if (  function_exists('is_shop')  ) {
                echo '<span class="active">'. esc_html($breadcrumb_page) . ' ' . get_query_var('paged') .'</span>';
            }
            else {
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo '<li class="breadcrumb-list"> ';
                echo  '<li class="active">'.esc_html($breadcrumb_page) . ' ' . get_query_var('paged').'</li>';
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo '</li>';
            }
            

        }
    }
}

/**
*
* pagination
*/
if( !function_exists('dogri_pagination') ) {

    function _dogri_pagi_callback($home) {
        return $home;
    }

    //page navegation
    function dogri_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
        
        if( $pages=='' ){
            global $wp_query;
            $pages = $wp_query->max_num_pages;
            
            if(!$pages)
                $pages = 1;
        }

        $pagination = array(
            'base' => add_query_arg('paged','%#%'),
            'format' => '',
            'total' => $pages,
            'current' => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type' => 'array'
        );

        //rewrite permalinks
        if( $wp_rewrite->using_permalinks() )
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );

        if( !empty($wp_query->query_vars['s']) )
            $pagination['add_args'] = array( 's' => get_query_var( 's' ) );

        $pagi = '';
        if(paginate_links( $pagination )!=''){
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul>';
                        foreach ($paginations as $key => $pg) {
                            $pagi.= '<li>'.$pg.'</li>';
                        }
            $pagi .= '</ul>';
        }

        echo _dogri_home_callback($pagi);
    }
}

add_action('admin_print_scripts', 'dogri_scripts_for_admin_panel', 1000);

function dogri_scripts_for_admin_panel(){
    if( get_post_type() == 'post' ) :
    ?>
        <script>
            (function ($) {
            "use strict";
                jQuery(document).ready(function(){

                    var postFormat = jQuery("input[name='post_format']:checked").attr('id');

                    if(postFormat == 'post-format-video'){
                        jQuery('.cmb2-id--video-url').show();
                    }else{
                        jQuery('.cmb2-id--video-url').hide();
                    }

                    if(postFormat == 'post-format-audio'){
                        jQuery('.cmb2-id--audio-url').show();
                    }else{
                        jQuery('.cmb2-id--audio-url').hide();
                    }

                    if(postFormat == 'post-format-gallery'){
                        jQuery('.cmb2-id--gallery-images').show();
                    }else{
                        jQuery('.cmb2-id--gallery-images').hide();
                    }

                    jQuery('input[name="post_format"]').change(function(){

                        var postFormat = jQuery("input[name='post_format']:checked").attr('id');

                        if(postFormat == 'post-format-video'){
                            jQuery('.cmb2-id--video-url').show();
                        }else{
                            jQuery('.cmb2-id--video-url').hide();
                        }

                        if(postFormat == 'post-format-audio'){
                            jQuery('.cmb2-id--audio-url').show();
                        }else{
                            jQuery('.cmb2-id--audio-url').hide();
                        }

                        if(postFormat == 'post-format-gallery'){
                            jQuery('.cmb2-id--gallery-images').show();
                        }else{
                            jQuery('.cmb2-id--gallery-images').hide();
                        }
                    });
                })

            })(jQuery);
        </script>

    <?php endif;
}

// header top bg color one
function dogri_header_top_bg_color(){
    $color_code = get_theme_mod( 'dogri_header_top_bg_color','#ffffff00');
    wp_enqueue_style( 'dogri_header_top_bg', DOGRI_THEME_CSS_DIR . 'color/dogri_header_top_bg.css', array());
    if($color_code!=''){
        $custom_css = '';
        $custom_css .= ".header-top{ background: ".$color_code."}";

        wp_add_inline_style('dogri_header_top_bg',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'dogri_header_top_bg_color');


// header top bg color two
function dogri_header_top_bg_color_2(){
    $color_code_2 = get_theme_mod( 'dogri_header_top_bg_color_2','#ffffff00');
    wp_enqueue_style( 'dogri_header_top_bg', DOGRI_THEME_CSS_DIR . 'color/dogri_header_top_bg.css', array());
    if($color_code_2!=''){
        $custom_css = '';
        $custom_css .= ".main-header.two .header-top{ background: ".$color_code_2."}"; 

        wp_add_inline_style('dogri_header_top_bg',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'dogri_header_top_bg_color_2');


// header top bg color three
function dogri_header_top_bg_color_3(){
    $color_code_3 = get_theme_mod( 'dogri_header_top_bg_color_3','#ffffff00');
    wp_enqueue_style( 'dogri_header_top_bg', DOGRI_THEME_CSS_DIR . 'color/dogri_header_top_bg.css', array());
    if($color_code_3!=''){
        $custom_css = '';
        $custom_css .= ".main-header.three .header-top{ background: ".$color_code_3."}";

        wp_add_inline_style('dogri_header_top_bg',$custom_css);
    }
}
add_action('wp_enqueue_scripts', 'dogri_header_top_bg_color_3');

add_action('wp_footer', 'dogri_action_example'); 
function dogri_action_example() { 
    ?>  

<!-- Back to top start -->
<div class="backtotop-wrap cursor-pointer">
    <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
    </svg>
</div>
<!-- Back to top end -->

    <?php 
}